/****************************************************************************
 *   LPC 8xx  SCT PWM for LPC824 expresso board
 *
 *   SCT program that implements a PWM with two different duty cycles.
 *   CTIN_0 selects between these two states.
 *   CTIN_0 = 1: Green LED flashes with large duty cycle
 *   CTIN_0 = 0: Red LED flashes with small duty cycle.

****************************************************************************/

#include "board.h"

#define C_match_green_OFF 	(2000000)
#define C_match_green_ON 	(1000000)
#define C_match_red_OFF 	(9000000)
#define C_match_red_ON 		(1000000)
#define delay 		        (10000000)

void sct_fsm_init (void);

void sct_fsm_init (void)
{

	Chip_SCT_Init(LPC_SCT);														/* enable the SCT clock     */

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_AUTOLIMIT_L		|
							 SCT_CONFIG_32BIT_COUNTER 	);						/* AUTOLIMIT_L UNIFIED */

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, delay);						/* match_cycle */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, delay);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_1, C_match_green_OFF);			/* match_green_OFF */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, C_match_green_OFF);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_2, C_match_green_ON);				/* match_green_ON */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_2, C_match_green_ON);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_3, C_match_red_OFF);				/* match_red_OFF */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_3, C_match_red_OFF);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_4, C_match_red_ON);				/* match_red_ON */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_4, C_match_red_ON);


	/* OUTPUT registers */

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_0, (CHIP_SCT_EVENT_T)( SCT_EVT_0	|
                                                                SCT_EVT_3	|
                                                                SCT_EVT_5	));  			 		/* LED_green */
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_4);

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_1, (CHIP_SCT_EVENT_T)( SCT_EVT_0	|
                                                                SCT_EVT_1	|
                                                                SCT_EVT_3	));  			 		/* LED_red */
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_1, SCT_EVT_2);


	Chip_SCT_Output(LPC_SCT, SCT_EVT_0 | SCT_EVT_1);

	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);					/* U: --> state state_1 */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)( SCT_EVECTRL_MATCH0	|
                                                                      SCT_COMBMODE_AND	  |
                                                                      SCT_STATELD_1		    |
                                                                      SCT_STATEEV_1		    ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE0);					/* U: --> state U_ENTRY */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T)( SCT_EVECTRL_MATCH3	|
                                                                      SCT_COMBMODE_MATCH	|
                                                                      SCT_STATELD_1		    |
                                                                      SCT_STATEEV_0		    ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_2, ENABLE_STATE0);					/* U: --> state U_ENTRY */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_2, (CHIP_SCT_EVENTCTRL_T)( SCT_EVECTRL_MATCH4	|
                                                                      SCT_COMBMODE_MATCH	|
                                                                      SCT_STATELD_1		    |
                                                                      SCT_STATEEV_0		    ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_3, ENABLE_STATE1);					/* U: --> state U_ENTRY */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T)( SCT_EVECTRL_MATCH0	|
                                                                      SCT_IOCOND_HIGH		  |
                                                                      SCT_COMBMODE_AND	  |
                                                                      SCT_STATELD_1		    |
                                                                      SCT_STATEEV_0		    ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_4, ENABLE_STATE1);					/* U: --> state state_1 */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_4, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH2	|
                                                                        SCT_COMBMODE_MATCH	|
                                                                        SCT_STATELD_1		    |
                                                                        SCT_STATEEV_1		    ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_5, ENABLE_STATE1);					/* U: --> state state_1 */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_5, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1	|
                                                                       SCT_COMBMODE_MATCH	|
                                                                       SCT_STATELD_1		  |
                                                                       SCT_STATEEV_1		  ));



	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}



int main(void)
{
	/* Generic Initialization */
	SystemCoreClockUpdate();
	Board_Init();

  Chip_SCT_Init(LPC_SCT);														/* enable the SCT clock */
  
  Chip_Clock_SetSysClockDiv(2);

	Chip_SWM_Init();
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);
  
  Chip_INMUX_SetSCTInMux(LPC_INMUX, SCT_INMUX_0, SCT_INP_IN0);
  
  Chip_SWM_DisableFixedPin(SWM_FIXED_ADC11);            //disable Pinmux for P0_4 (ADC11)

	Chip_SWM_MovablePinAssign(SWM_SCT_IN0_I,   4);					/* CTIN_0->PIO0_4             */
	Chip_SWM_MovablePinAssign(SWM_SCT_OUT0_O, 16);						/* CTOUT_0->PIO0_16 (green)   */
	Chip_SWM_MovablePinAssign(SWM_SCT_OUT1_O,  12);						/* CTOUT_1->PIO0_12 (red)      */

	

	sct_fsm_init();              /* Initialize the SCT using the code generated by Red State */

     while(1)
    {
    	__WFI();
    }
}
